/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.recipe;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.data.recipe.BaseShapelessRecipeBuilder;

public class ShapelessRecipeBuilder
extends BaseShapelessRecipeBuilder<ShapelessRecipe, ShapelessRecipeBuilder> {
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private RecipeCategory category = RecipeCategory.MISC;
    private String group = "";

    public ShapelessRecipeBuilder(@Nullable String directory) {
        super(directory);
    }

    public ShapelessRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public ShapelessRecipeBuilder category(RecipeCategory category) {
        this.category = category;
        return this;
    }

    public ShapelessRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    @Override
    protected ShapelessRecipeBuilder builder() {
        return this;
    }

    @Override
    public RecipeHolder<ShapelessRecipe> build() {
        if (this.id == null) {
            this.id = ((ResourceKey)this.result.getItemHolder().unwrapKey().orElseThrow()).location();
        }
        ShapelessRecipe recipe = new ShapelessRecipe(this.group, RecipeBuilder.determineBookCategory((RecipeCategory)this.category), this.result, this.ingredients);
        return new RecipeHolder(this.id, (Recipe)recipe);
    }

    @Override
    @Nullable
    public AdvancementHolder buildAdvancement() {
        if (this.id == null) {
            this.id = ((ResourceKey)this.result.getItemHolder().unwrapKey().orElseThrow()).location();
        }
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)this.id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)this.id)).requirements(AdvancementRequirements.Strategy.OR);
        if (!this.criteria.isEmpty()) {
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        }
        return builder.build(this.id.withPrefix("recipes/"));
    }
}

